;========================================================================================
;  flineprivilege.s
;  Copyright (C) 2003-2024 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------------------------------
;
;	flineprivilege.x
;		MC68030Ń[U[ĥƂ$FE00`$FFFF̂ǂœᔽO邩ׂ܂B
;		u.vFCÔĂAu!v͓ᔽÔĂ܂B
;		cpSAVE܂cpRESTOREŃAhbVO[hꍇɌAFCOł͂ȂᔽO܂B
;
;	XV
;		2024-11-29
;			JB
;
;----------------------------------------------------------------------------------------

	.include	doscall.mac
	.include	iocscall.mac
	.include	control2.mac

	.text

;ʂ̃obt@
	lea.l	result_buffer,a2	;a2=ʂ̃obt@̃|C^

;ȏ邽߃LbVOFFɂ
	moveq.l	#-1,d3			;d3=̃LbV[h
	movem.l	sp,-(sp)
	cmpa.l	(sp)+,sp
	if	ne			;68020ȏ
		moveq.l	#0,d2
		moveq.l	#4,d1
		IOCS	_SYS_STAT
		move.l	d0,d3
	endif

;ᔽOxN^ۑĕύX
	moveq.l	#$08,d1			;ᔽO
	lea.l	privilege_routine,a1	;ᔽO[`
	IOCS	_B_INTVCS
	movea.l	d0,a3			;a3=̓ᔽOxN^

;FCOxN^ۑĕύX
	moveq.l	#$0B,d1			;FCO
	lea.l	fline_routine,a1	;FCO[`
	IOCS	_B_INTVCS
	movea.l	d0,a4			;a4=FCOxN^

;$FE00`$FFFFs
	move.w	#$FE00,d1		;d1=߃R[h
	do
		move.w	d1,@f			;ȏ
		nop
		.align	4,$4E71			;܂Ȃ
	@@:	nop
		addq.w	#1,d1
		moveq.l	#63,d0			;64
		and.w	d1,d0
		if	eq
			move.b	#13,(a2)+		;s
			move.b	#10,(a2)+
		else
			moveq.l	#15,d0			;16
			and.w	d1,d0
			if	eq
				move.b	#' ',(a2)+		;
			endif
		endif
	while	<tst.w d1>,ne

;ᔽOxN^𕜌
	moveq.l	#$08,d1			;ᔽO
	movea.l	a3,a1			;̓ᔽOxN^
	IOCS	_B_INTVCS

;FCOxN^𕜌
	moveq.l	#$0B,d1			;FCO
	movea.l	a4,a1			;FCOxN^
	IOCS	_B_INTVCS

;LbV[h𕜌
	move.l	d3,d2			;̃LbV[h
	if	pl			;68020ȏ
		moveq.l	#4,d1
		IOCS	_SYS_STAT
	endif

;ʂ\
	clr.b	(a2)
	pea.l	result_buffer
	DOS	_PRINT
	addq.l	#4,sp

;I
	DOS	_EXIT

;ᔽO[`
privilege_routine:
	move.b	#'!',(a2)+
	addq.l	#2,2(sp)		;̖߂ɐi
	rte

;FCO[`
fline_routine:
	move.b	#'.',(a2)+
	addq.l	#2,2(sp)		;̖߂ɐi
	rte

	.bss

;ʂ̃obt@
result_buffer:
	.ds.b	4096
